(*| 15:19 13/11/1990 *)
Unit SCRNDRV;

Interface

USES Vars;

VAR
   ScrnAddr : Integer;     {Offset of screen position within screen ram}
   Retracemode: boolean;    { Set if wait for vertical retrace is needed }

CONST
  ScreenBase : Word = $B800;  {Base of screen Ram}
{! 17. Assign unsigned va^lues of $8000 or larger only to Word or LongInt types.}
  WUpperleft = 201; { '' }
  WUpperright= 187; { '' }
  WLowLeft   = 200; { '' }
  WLowRight  = 188; { '' }
  WHorizontal= 205; { '' }
  WVertical  = 186; { '' }

  MaxWindowX   = MaxTVCol+2;         { Maximum columns in window             }
  MaxWindowY   = MaxTVRow+2;         { Maximum lines in window for prompt    }
  MaxWindowX0  = MaxTVCol+1;         { Maximum columns in window             }
  MaxWindowY0  = MaxTVRow+1;         { Maximum lines in window for prompt    }
TYPE
  SavedWindowType =array[0..MaxwindowY0,0..MaxWindowX0] of integer;
VAR
{ Colors for the pulldown menus                                              }
  PNormColor  : integer;             { Color of non-selected parts           }
  PLowColor   : integer;             { Color of selected parts               }
  PFrameColor : integer;             { Color of frame                        }

{ Colors for the windows                                                     }
  WNormColor  : integer;             { Color of non-selected parts           }
  WLowColor   : integer;             { Color of selected parts               }
  WFrameColor : integer;             { Color of frame                        }

  MenuColor    :Integer;               { Current color                       }
  WArray       :SavedWindowType;

{//////////////////////////////////////////////////////////////////////
//               MicroStar Version 1.00B                             //
//               Module : SCREEN.MS                                  //
//////////////////////////////////////////////////////////////////////}

                 { LOW-LEVEL SCREEN UPDATE ROUTINES }

{ The following routines allow the editor to move data directly to and }
{ from screen memory without causing snow or flicker. They are written }
{ as inline assembly language for speed; the source is included below. }


procedure MoveToScreen(Var Source,Dest; Length: Integer);
{  Move memory, as Turbo Move, but assume that the target is in
   video memory; prevent screen flicker based on this assumption,
   unless RetraceMode is false.  Timing is VERY tight: if the code
   were 1 clock cycle slower, it would cause flicker.
}
  
procedure MoveFromScreen(Var Source,Dest; Length: Integer);
{  Move memory, as Turbo Move, but assume that the source is in
   video memory; prevent screen flicker based on this assumption,
   unless RetraceMode is false.  Timing is VERY tight: if the code
   were 1 clock cycle slower, it would cause flicker.
}

procedure SetMemAddress(Col,Line:byte);
{
1.  Proc. Name
    SetMemAddress -- set the next address in vidoe RAM to be written to.

2.  Functional Description
    The global variable ScrnAddr is assigned the value of the next location
    on the screen to be written to.
}

procedure WriteChar(ch:byte);
{
1.  Proc. Name
    WriteChar -- write a character to the screen

2.  Functional Description
    The local variable screenword is used to combine the character and it's
    corresponding video attributes. The integer is then written directly to
    video RAM using the MoveToScreen routine.
}

procedure WriteString(Var st);
{
1.  Proc. Name
    WriteString -- writes a string to video RAM

2.  Functional Description
    The untyped paramater passed to the routine represents a string. The string
    is copied directly from video RAM uses the length byte (Offset zero) as
    to maximum value of the counter.
}

procedure SaveScreen(Var Adr; Num:byte);
{
1.  Proc. Name
    SaveScreen -- Saves area of screen to temporary buffer

2.  Functional Description
    The paramater Adr passed to this routine is used as a temporary buffer
    to hold the next Num characters on the screen.
}

procedure RestoreScreen(var Adr; Num:byte);
{
1.  Proc. Name
    RestoreScreen -- restore the original contents of the screen
 
2.  Functional Description
    The screen is restored with the contents of Adr
}

procedure MakeWindow(col,line,NumOfCols,NumOfLines: byte);
{
1.  Proc. Name
    MakeWindow -- makes a window of the specified columns X rows
 
2.  Functional Description
    The paramaters passed to this routine indicate the starting position
    and size of the window to be displayed. Based on this information, the
    windows frame is displayed and the inside of the wondow is filled with
    spaces.
}

procedure UnmakeWindow(col,line,NumOfCols,NumOfLines : byte);
{
1.  Proc. Name
    UnmakeWindow -- Restore the screen "under" the window

2.  Functional Description
    The indicated position on the screen is restored to its original contents.
}

PROCEDURE InitScrnDrv;


{===========================================================================}

Implementation

USES Dos{,Screen};

FUNCTION ScreenWidth: Integer;  {ex SCREEN.PAS}
{Read current video mode to get current screen width:}
Var Regs: Registers;
BEGIN
  Regs.AX:= $0F00;          {service to get current video mode}
  Intr($10,Regs);         {and perform service}
  ScreenWidth:= Hi(Regs.AX);      {get screen width from returned values}
END;  {ScreenWidth}

{MODULE SCREENDRV}

{Direct write screen driving routines:}
{=====================================}


procedure MoveToScreen(Var Source,Dest; Length: Integer);
{  Move memory, as Turbo Move, but assume that the target is in
   video memory; prevent screen flicker based on this assumption,
   unless RetraceMode is false.  Timing is VERY tight: if the code
   were 1 clock cycle slower, it would cause flicker.
}
  
Begin
    If Not RetraceMode Then Move(Source,Dest,Length)
    Else
     Begin
      Length:=Length Shr 1;
      Inline($1E/$55/$BA/$DA/$03/$C5/$B6/ Source /$C4/$BE/ Dest /$8B/$8E/
{! 18.^ New stack conventions require that many Inlines be rewritten.}
             Length /$FC/$AD/$89/$C5/$B4/$09/$EC/$D0/$D8/$72/$FB/$FA/$EC/
             $20/$E0/$74/$FB/$89/$E8/$AB/$FB/$E2/$EA/$5D/$1F);
{
        push    ds              ; Save Turbo's DS
        push    bp              ;   and BP
        mov     dx,3da          ; Point DX to CGA status port
        lds     si,source[bp]   ; Source pointer into DS:SI
        les     di,dest[bp]     ; Dest pointer into ES:DI
        mov     cx,length[bp]   ; Length value into CX
        cld                     ; Set string direction to forward
.0:     lodsw                   ; Grab a video word
        mov     bp,ax           ; Save it in BP
        mov     ah,9            ; Move horiz. + vertical retrace mask to fast
                                ;   storage
.1:     in      al,dx           ; Get 6845 status
        rcr     al,1            ; Check horizontal retrace
        jb      .1              ; Loop if in horizontal retrace: this prevents
                                ;   starting in mid-retrace, since there is
                                ;   exactly enough time for 1 and only 1 STOSW
                                ;   during horizontal retrace
        cli                     ; No ints during critical section
.2:     in      al,dx           ; Get 6845 status
        and     al,ah           ; Check for both kinds of retrace: IF the
                                ;   video board does not report horizontal
                                ;   retrace while in vertical retrace, this
                                ;   will allow several characters to be
                                ;   stuffed in during vertical retrace
        jnz     .2              ; Loop if not equal zero
        mov     ax,bp           ; Get the video word
        stosw                   ; Store the video word
        sti                     ; Allow interrupts
        loop    .0              ; Go do next word
        pop     bp              ; Restore Turbo's BP
        pop     ds              ;   and DS
}
     End;
  End;


procedure MoveFromScreen(Var Source,Dest; Length: Integer);
{  Move memory, as Turbo Move, but assume that the source is in
   video memory; prevent screen flicker based on this assumption,
   unless RetraceMode is false.  Timing is VERY tight: if the code
   were 1 clock cycle slower, it would cause flicker.
}

Begin
    If Not RetraceMode Then Move(Source,Dest,Length)
    Else
     Begin
      Length:=Length Shr 1;
      Inline($1E/$55/$BA/$DA/$03/$C5/$B6/ Source /$C4/$BE/ Dest /$8B/$8E/
{! 19.^ New stack conventions require that many Inlines be rewritten.}
             Length /$FC/$EC/$D0/$D8/$72/$FB/$FA/$EC/$D0/$D8/$73/$FB/$AD/
             $FB/$AB/$E2/$F0/$5D/$1F);
{
        push    ds              ; Save Turbo's DS
        push    bp              ;   and BP
        mov     dx,3da          ; Point DX to CGA status port
        lds     si,source[bp]   ; Source pointer into DS:SI
        les     di,dest[bp]     ; Dest pointer into ES:DI
        mov     cx,length[bp]   ; Length value into CX
        cld                     ; Set string direction to forward
.0:     in      al,dx           ; Get 6845 status
        rcr     al,1            ; Check horizontal retrace
        jb      .0              ; Loop if in horizontal retrace: this prevents
                                ;   starting in mid-retrace, since there is
                                ;   exactly enough time for 1 and only 1 LODSW
                                ;   during horizontal retrace
        cli                     ; No ints during critical section
.1:     in      al,dx           ; Get 6845 status
        rcr     al,1            ; Check for horizontal retrace: LODSW is 1
                                ;   clock cycle slower than STOSW; because of
                                ;   this, the vertical retrace trick can't be
                                ;   used because it causes flicker!  (RCR AL,1
                                ;   is 1 cycle faster than AND AL,AH)
        jnb     .1              ; Loop if not in retrace
        lodsw                   ; Load the video word
        sti                     ; Allow interrupts
        stosw                   ; Store the video word
        loop    .0              ; Go do next word
        pop     bp              ; Restore Turbo's BP
        pop     ds              ;   and DS
}
     End;
  End;

                    { MICROSTAR-SPECIFIC SCREEN ROUTINES }


procedure SetMemAddress(Col,Line:byte);
{
1.  Proc. Name
    SetMemAddress -- set the next address in vidoe RAM to be written to.

2.  Functional Description
    The global variable ScrnAddr is assigned the value of the next location
    on the screen to be written to.
}

begin { procedure SetMemAddress }
  ScrnAddr := Pred(Line) * ScreenWidth*2 + (Pred(Col) * 2);
            { get line and column offsets }
end;  { procedure SetMemAddress }


procedure WriteChar(ch:byte);
{
1.  Proc. Name
    WriteChar -- write a character to the screen

2.  Functional Description
    The local variable screenword is used to combine the character and it's
    corresponding video attributes. The integer is then written directly to
    video RAM using the MoveToScreen routine.
}

var
  screenword : integer;
begin { procedure WriteChar }
  screenword := MenuColor + ch;       { add sceen attributes to character    }
  MoveToScreen(screenword,MemW[ScreenBase:ScrnAddr],2);
  ScrnAddr := ScrnAddr + 2;               { increment video RAM location counter }
end;  { procedure WriteChar }


procedure WriteString(Var st);
{
1.  Proc. Name
    WriteString -- writes a string to video RAM

2.  Functional Description
    The untyped paramater passed to the routine represents a string. The string
    is copied directly from video RAM uses the length byte (Offset zero) as
    to maximum value of the counter.
}

var
  count : integer;
begin { procedure WriteString }
  for count := 1 to Mem[Seg(st):Ofs(st)] do    { for st[1] to st[length(st)] }
    WriteChar(Mem[Seg(st):Ofs(st) + count]);   { display the character       }
end;  { procedure WriteString }



procedure SaveScreen(Var Adr; Num:byte);
{
1.  Proc. Name
    SaveScreen -- Saves area of screen to temporary buffer

2.  Functional Description
    The paramater Adr passed to this routine is used as a temporary buffer
    to hold the next Num characters on the screen.
}

begin { procedure SaveScreen }
  MoveFromScreen(Mem[ScreenBase:ScrnAddr],Adr,Num shl 1); { Num shl 1 = Num * 2 }
end;  { procedure SaveScreen }


procedure RestoreScreen(var Adr; Num:byte);
{
1.  Proc. Name
    RestoreScreen -- restore the original contents of the screen

2.  Functional Description
    The screen is restored with the contents of Adr
}

begin { procedure RestoreScreen }
  MoveFromScreen(Adr,Mem[ScreenBase:ScrnAddr],Num shl 1); { Num shl 1 = Num * 2 }
end;  { procedure RestoreScreen }


procedure MakeWindow(col,line,NumOfCols,NumOfLines: byte);
{
1.  Proc. Name
    MakeWindow -- makes a window of the specified columns X rows

2.  Functional Description
    The paramaters passed to this routine indicate the starting position
    and size of the window to be displayed. Based on this information, the
    windows frame is displayed and the inside of the wondow is filled with
    spaces.
}

var
  count1, count2 : integer;
begin { procedure MakeWindow }
  SetMemAddress(Col,Line);                         { set start address       }
  SaveScreen(Warray[0,0],NumOfCols);               { save text on screen     }
  MenuColor := WFrameColor;                        { update display color    }
  WriteChar(WUpperleft);                           { display left corner     }
  for count1 := Succ(col) to (col + NumOfCols - 2) do  { display  line       }
    WriteChar(WHorizontal);
  WriteChar(WUpperRight);                          { display right corner    }
  for count1 := (line + 1) to (line + NumOfLines - 2) do
  begin                                            { now draw the middle     }
    SetMemAddress(Col,count1);                     { rows                    }
    SaveScreen(WArray[count1 - line,0],NumOfCols); { save text on screen     }
    WriteChar(WVertical);                          { write left border       }
    MenuColor := WNormColor;                       { update display color    }
    for count2 := Succ(col) to (col + NumOfCols - 2) do
      WriteChar(32);                               { fill window with spaces }
    MenuColor := WFrameColor;                      { update display color    }
    WriteChar(WVertical);                          { write right border      }
  end;
  SetMemAddress(Col,line + NumOfLines - 1);        { set address to display  }
  SaveScreen(WArray[Pred(NumOfLines),0],NumOfCols);{ save text on screen     }
  WriteChar(WLowleft);                             { write left corner       }
  for count1 := Succ(col) to (col + NumOfCols - 2) do
    WriteChar(WHorizontal);                        { write middle of line    }
  WriteChar(WLowRight);                            { write right corner      }
end;  { procedure MakeWindow }


procedure UnmakeWindow(col,line,NumOfCols,NumOfLines : byte);
{
1.  Proc. Name
    UnmakeWindow -- Restore the screen "under" the window

2.  Functional Description
    The indicated position on the screen is restored to its original contents.
}

var
  count : integer;
begin { procedure UnmakeWindow }
  for count := (line + Pred(NumOfLines)) downto line do
  begin
    SetMemAddress(Col,count);                    { calculate screen location }
    RestoreScreen(WArray[count - line],NumOfCols); { re-display contents     }
  end;
end;  { procedure UnmakeWindow }


PROCEDURE InitScrnDrv;


var
  Regs : Registers;

begin
  { Determine screen type }

  Regs.AX := $0F00;                 {See turbo 3.0 manual, pg 214}
  Intr ($010, Dos.Registers(Regs));                {BIOS INT 10H call to get screen type}
  Retracemode := (Regs.AX and $00FF) <> 7;
  If Retracemode then
  begin
    ScreenBase := $B800;            {Address of color screen}
{! 20. Assign unsi^gned values of $8000 or larger only to Word or LongInt types.}
    PNormColor  := $3100;           {Color of non-selected parts}
    PLowColor   := $7800;           {Color of selected parts    }
    PFrameColor := $0300;           {Color of frame             }

    WNormColor  := $0700;           {Color of non-selected parts}
    WLowColor   := $7000;           {Color of selected parts    }
    WFrameColor := $0300;           {Color of frame             }
  end else
  begin
    ScreenBase := $B000;             {Address of monochrome screen}
{! 21. Assign unsi^gned values of $8000 or larger only to Word or LongInt types.}
    PNormColor := $0F00;            {As above}
    PLowColor  := $7000;
    PFrameColor := $1000;

    WNormColor := $0F00;
    WLowColor  := $7000;
    WFrameColor := $1000;
  end;
  RetraceMode:= False;              {For Zenith no need for retrace mode}
end;  { InitScrnDrv}

begin
  InitScrnDrv;
End.
